/* - StepperPositionListener -
 * Display the position data from the position change event
 *
 * Copyright 2007 Phidgets Inc.  
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */

package listeners;

import com.phidgets.event.StepperPositionChangeListener;
import com.phidgets.event.StepperPositionChangeEvent;

import javax.swing.JComboBox;
import javax.swing.JTextField;

public class StepperPositionListener implements StepperPositionChangeListener{
    
    private JComboBox motorCmb;
    private JTextField posTxt;
    
    /**
     * Creates a new instance of StepperPositionListener
     */
    public StepperPositionListener(JComboBox motorCmb, JTextField posTxt)
    {
        this.motorCmb = motorCmb;
        this.posTxt = posTxt;
    }

    public void stepperPositionChanged(StepperPositionChangeEvent stepperPositionChangeEvent)
    {
        if(stepperPositionChangeEvent.getIndex() == ((Integer)motorCmb.getSelectedItem()).intValue())
        {
            posTxt.setText(Double.toString(stepperPositionChangeEvent.getValue()));
        }
    }
    
}
